/*
 *  "notify" will send the given message to the given user's terminal(s)
 *  if they are logged on and/or send the message as mail, depending
 *  on the mode flag.  Valid settings are:
 *
 *           0 - terminal if logged on, mail otherwise
 *           1 - terminal if logged on, mail in any case
 *           2 - terminal only
 *           3 - mail only
 *
 * If the user name has the format system!user, then
 * a request is sent to that system to notify the user.
 */
 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>
#include <utmp.h>

static FILE *uf;
 
notify(user,mesg,mode) char *user, *mesg;
{
	register int term = 0;
        char ttyname[20], *sys, *cp, *vmid();
        FILE *fd;
 
	if(cp = index(user, '!')) {
		sys = user;
		user = cp+1;
		*cp = '\0';
		for(cp = sys; *cp; cp++)
			if(islower(*cp)) *cp = toupper(*cp);
		if(strcmp(sys, vmid()) != 0) {
			xnotify(sys, user, mesg, mode);
			return;
		}
	}

        /* is user logged on a writable terminal? */
        if (mode!=3) {
                if((uf = fopen("/etc/utmp", "r")) != NULL) {
                        while(gettname(user, ttyname) >= 0) {
                                if ((fd=fopen(ttyname,"w")) != NULL) {
                                        term++;
                                        fprintf(fd, "\n\n%s\007\n\n", mesg);
                                        fclose(fd);
                                }
                        }
                        fclose(uf);
		}
                if (mode==2 || (term>0 && mode==0)) return;
        }

        /* send them mail */
        mail(user, mesg);
}
 
static gettname(user, name) char *user, *name;
{
/*
 *  this thing looks in the /etc/utmp file to see if the given user
 *  is logged on.  If yes, and the tty file is writable by all, the
 *  user's tty file name is returned.
 */
	struct utmp utmp;
        struct stat sb;
 
        while(fread((char *)&utmp, sizeof(utmp), 1, uf) == 1) {
                if(strncmp(user, utmp.ut_name, 8) == 0) {
                        sprintf(name, "/dev/%s", utmp.ut_line);
                        if (stat(name, &sb)>=0 && (sb.st_mode&022)==022)
                                return(0);
                }
        }
        return(-1);
}


#define pin  pd[0]
#define pout pd[1]
 
static mail(user, mesg) char *user, *mesg;
{
/*
*  fork a new process and execute the /bin/mail command, passing
*  it the message as its input through the pipe.
*/
        int i, try, status;
	int pd[2];
 
        if (pipe(pd) < 0) {
                fprintf(stderr, "notify: pipe call failed\n");
                return;
        }
        for (try=0; try<10; try++) {
                if ((i = fork()) >= 0) break;
                sleep(2);
        }
        if (i < 0) {
                fprintf(stderr, "notify: fork call failed\n");
                return;
        }
        if (i == 0) {                  /* child */
                close(pout);
                movefd(pin, 0);
                close(1);
                open ("/dev/null", 1);
                execl("/bin/mail", "mail", user, 0);
                fprintf(stderr, "notify: exec of /bin/mail failed\n");
                exit(1);
        }
        close(pin);                  /* parent */
        write(pout, mesg, strlen(mesg));
        write(pout, "\n", 1);
        close(pout);
        while(wait(&status) != i) ;
        return;
}

/*
 * Invoke vmpunch to send a cross-system notification
 */
static xnotify(sys, user, mesg, mode)
char *sys, *user, *mesg;
{
/*
*  fork a new process and execute the vmpunch command, passing
*  it the message as its input through the pipe.
*/
        int i, try, status;
	int pd[2];
	char tag[80];
 
	sprintf(tag, "notify:%s:%d", user, mode);

        if (pipe(pd) < 0) {
                fprintf(stderr, "notify: pipe call failed\n");
                return;
        }
        for (try=0; try<10; try++) {
                if ((i = fork()) >= 0) break;
                sleep(2);
        }
        if (i < 0) {
                fprintf(stderr, "notify: fork call failed\n");
                return;
        }
        if (i == 0) {                  /* child */
                close(pout);
                movefd(pin, 0);
                close(1);
                open ("/dev/null", 1);
                execl("/bin/vmpunch", "vmpunch", "-v", sys, "-i", user, "-x", tag, 0);
                fprintf(stderr, "notify: exec of vmpunch failed\n");
                exit(1);
        }
        close(pin);                  /* parent */
        write(pout, mesg, strlen(mesg));
        write(pout, "\n", 1);
        close(pout);
        while(wait(&status) != i) ;
        return;
}
