#define MAXDEV 256               /* maximum number of devices */


/*
 * Local data structures
 */

struct  device {
        struct device *devdevice;/* pointer to next device structure */
        struct type   *devtype;  /* pointer to type structure */
        int    devmajor;         /* major number for device */
        int    devminor;         /* minor number for device */
        int    devaddress;       /* device address */
        char   *devtty;          /* pointer to tty code */
	char   *devmount;        /* pointer to mount directory */
};

struct  type {
        char   *typtype;         /* pointer to type string */
        int    typdriver;        /* driver type */
        char   *typnmpfx;        /* pointer to special file name prefix */
        int    typmode;          /* mode */
        char   *typtty;          /* pointer to tty code */
};

struct  driver {
        int    drvname;          /* driver type */
        char   *drvtype;         /* driver type - "c", "b", "d", or "p" */
        int    drvmajor;         /* major number for driver */
        struct device *drvdevice;/* pointer to list of device structures */
        char   *drvadtab;        /* pointer to driver address table name string */
        char   *drveps;          /* pointer to driver entry point string */
	int    drvnum;          /* number of devices on drvdevice chain */
};

/*
 * Structure for dummy devices (root, pipe, dump, etc.)
 */
struct dmydrv {
	char    *dmyname;
	int     dmytype;
	struct  device *dmydevice;
};

/*
 *  Structure for each line of the new ioconf.h file.
 */
struct confhdr {
	int     c_driver;               /* driver type */
	char    *c_define;              /* #define constant name */
	int     c_num;                  /* default value */
	char    *c_comment;             /* comment */
};

/*
 *
 *  Spooler table for the spoollist
 */
struct  spool   {
	int     sp_drvtype;
	char    *sp_key;
	char    *sp_daem;
	struct  device  *sp_dev;
};

/*
 *  Driver types
 *  This are arbitrary integers representing the different types
 *  of drivers.  Zero can not be used.
 */
#define D_CONS          1
#define D_DASD          2
#define D_RDASD         3
#define D_FDASD         4
#define D_VIO           5
#define D_TAPE          6
#define D_TERM          7
#define D_TUBE          8
#define D_FULLSCRN      9
#define D_PRT           10
#define D_RDR           11
#define D_PUN           12
#define D_LDEV          13
#define D_SMSG          14
#define D_CPCMD         15
#define D_VMCF          16
#define D_PVM           17
#define D_DIR           18
#define D_MEM           19
#define D_TAGRDR        20
#define D_SYSTTY        21
#define D_ROOT          22
#define D_PIPE          23
#define D_DUMP          24
