#include <sys/param.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <signal.h>

#define BUFFACT 3       /* number of buffers worth of data to read and write at once */
#define NS      128     /* max file name size */
 
#define NLNK 50
struct lnk {
        ino_t   l_ino;
        dev_t   l_dev;
        char    l_name[NS];
} lnktab[NLNK];

char buf[BUFFACT*BSIZE];

int stop = 0;
int catch();
 
main(argc,argv)
int argc;
char **argv;
{
        if(argc != 3) {
                printf("Arg count\n");
                return;
        }
	if(signal(SIGHUP, SIG_IGN) != SIG_IGN)
		signal(SIGHUP, catch);
	if(signal(SIGINTR, SIG_IGN) != SIG_IGN)
		signal(SIGINTR, catch);
	if(signal(SIGQUIT, SIG_IGN) != SIG_IGN)
		signal(SIGQUIT, catch);
	if(signal(SIGTERM, SIG_IGN) != SIG_IGN)
		signal(SIGTERM, catch);
	umask(0);
        cpt(argv[1], argv[2]);
}

catch(sig)
{
	signal(sig, catch);
	stop = 1;
}

 
cpt(ifn, ofn)
char *ifn, *ofn;
{
        char nifn[NS], nofn[NS];
        struct direct dir;
        struct stat sbuf;
        int ifd, ofd, n;
 
	if(stop) {
		printf("cpt: terminated\n");
		exit(1);
	}
        if(stat(ifn, &sbuf)) {
                printf("%s: non existent\n", ifn);
                return;
        }
        switch(sbuf.st_mode & S_IFMT) {
 
        case S_IFREG:     /* regular file */
                if(linkchk(ifn, ofn, &sbuf)) return;
                if((ifd = open(ifn, 0)) < 0) {
                        printf("%s: cannot open\n");
                        return;
                }
                if((ofd = creat(ofn, sbuf.st_mode & 07777)) < 0) {
                        printf("%s: cannot create\n", ofn);
                        close(ifd);
                        return;
                }
                chown(ofn, sbuf.st_uid, sbuf.st_gid);
		/* must chmod to set sticky bit if needed */
		chmod(ofn, sbuf.st_mode & 07777);
                while((n = read(ifd, buf, sizeof buf)) > 0)
                        if(write(ofd, buf, n) != n) {
                                printf("%s: write error\n", ofn);
                                return;
                        }
                if(n < 0)
                        printf("%s: read error\n", ifn);
                close(ifd);
                close(ofd);
                break;
 
        case S_IFCHR:
        case S_IFBLK:
                /* special file */
                if(linkchk(ifn, ofn, &sbuf)) return;
                mknod(ofn, sbuf.st_mode, sbuf.st_rdev);
                chown(ofn, sbuf.st_uid, sbuf.st_gid);
                break;
 
        case S_IFDIR:     /* directory */
                mkdir(ofn, sbuf.st_mode);
                chown(ofn, sbuf.st_uid, sbuf.st_gid);
                if((ifd = open(ifn, 0)) < 0) {
                        printf("%s: cannot open\n", ifn);
                        return;
                }
                while(read(ifd, (char *)&dir, sizeof dir) == sizeof dir) {
                        if(dir.d_ino == 0) continue;
                        if(strncmp(dir.d_name, ".", DIRSIZ) == 0) continue;
                        if(strncmp(dir.d_name, "..", DIRSIZ) == 0) continue;
                        tack(ifn, dir.d_name, nifn);
                        tack(ofn, dir.d_name, nofn);
                        cpt(nifn, nofn);
                }
                close(ifd);
                break;
        }      /* end of switch */
	utime(ofn, &sbuf.st_atime);
}
 
tack(p, q, r)
char *p, *q, *r;
{
	int i;

        while(*r = *p++) r++;
        *r++ = '/';
        for(i=0; i<DIRSIZ && *q; i++)
		*r++ = *q++;
	*r = '\0';
}

linkchk(ifn, ofn, st)
char *ifn;
char *ofn;
struct stat *st;
{
        struct lnk *p, *q;

        if(st->st_nlink == 0) {
                printf("%s: bad link count\n", ifn);
                return(1);
        }
        if(st->st_nlink == 1) return(0);
        q = 0;
        for(p = lnktab; p < &lnktab[NLNK]; p++) {
                if(st->st_ino == p->l_ino && st->st_dev == p->l_dev) {
                        if(link(p->l_name, ofn)) {
                                printf("%s: cannot link to %s\n", ofn, p->l_name);
                        }
                        return(1);
                }
                if(q == 0 && p->l_ino == 0) q = p;
        }
        if(q == 0) {
                printf("Link table overflow -- aborting\n");
                exit(1);
        }
        q->l_ino = st->st_ino;
        q->l_dev = st->st_dev;
        strcpy(q->l_name, ofn);
        return(0);
}

/*
 * Create a directory with the given name and mode
 */
mkdir(d, mode)
char *d;
int mode;
{
	char pname[NS], dname[NS];
	register i, slash = 0;

	pname[0] = '\0';
	for(i = 0; d[i]; ++i)
		if(d[i] == '/')
			slash = i + 1;
	if(slash)
		strncpy(pname, d, slash);
	strcpy(pname+slash, ".");
	if (access(pname, 02)) {
		printf("Cannot access %s\n", pname);
		return;
	}
	if ((mknod(d, mode, 0)) < 0) {
		printf("Cannot make directory %s\n", d);
		return;
	}
	strcpy(dname, d);
	strcat(dname, "/.");
	if((link(d, dname)) < 0) {
		printf("Cannot link %s\n", dname);
		unlink(d);
		return;
	}
	strcat(dname, ".");
	if((link(pname, dname)) < 0) {
		printf("Cannot link %s\n",dname);
		dname[strlen(dname)] = '\0';
		unlink(dname);
		unlink(d);
	}
}
