/*
 *      ps - process status
 *      examine and print certain things about processes
 */

#include <stdio.h>
#include <a.out.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/tty.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/stat.h>

struct proc proc[NPROC];
struct user user;

#define PTSIZE 16
struct pagetab {
	int     *pt_next;
	int     pt_junk;
	short   pt_entry[PTSIZE];
} pagetab;

int     lflg;
int     kflg;
int     xflg;
int     tflg;
int     aflg;
int     mem;
int     prot;

int     ndev;
char    devc[65][16];
int     devl[65];
char    *coref;
char    *procf;

main(argc, argv)
char **argv;
{
        struct proc *p;
        int i, c;
        char *ap;
        char *mtty;
        char *cs;
        char *ttyname();
        int uid, puid;
	int err = 0;

        if (argc>1) {
                ap = argv[1];
                while (*ap) switch (*ap++) {
                case 'a':
                        aflg++;
                        break;

                case 't':
                        tflg++;
                        break;

                case 'x':
                        xflg++;
                        break;

                case 'l':
                        lflg++;
                        break;

                case 'k':
                        kflg++;
                        break;

                }
        }

        if(chdir("/dev") < 0) {
                fprintf(stderr, "cannot change to /dev\n");
                done(1);
        }
        if(kflg) {
                coref = "/usr/sys/core";
                procf = "/usr/sys/proc";
	}
	else {
	        coref = "/dev/mem";
	        procf = "/dev/kmem/proc";
	}
        if ((mem = open(coref, 0)) < 0) {
                fprintf(stderr, "ps: No mem\n");
                done(1);
        }
        if ((prot = open(procf, 0)) < 0) {
                fprintf(stderr, "ps: No process table\n");
                done(1);
        }
        if(read(prot, (char *)proc, sizeof proc) != sizeof proc ||
           read(prot, &c, 1) != 0)
		fprintf(stderr, "ps: out of date, recompile ps\n");
        getdev();
        mtty = ttyname(0);
        uid = getuid();
	if (tflg && lflg)
	        printf("TTY     F S UID   PID  PPID  PGRP PRI  WCHAN PAGES    TIME COMMAND\n");
        else if (lflg)
	        printf("TTY     F S UID   PID  PPID  PGRP PRI  WCHAN PAGES COMMAND\n");
	else if (tflg)
		printf("TTY      PID    TIME COMMAND\n");
	else
		printf("TTY      PID COMMAND\n");
        for (i=0; i<NPROC; i++) {
                if (proc[i].p_stat==0)
                        continue;
	        seek(mem, (int)proc[i].p_addr, 0);
	        if (read(mem, (char *)&user, sizeof user) != sizeof user){
			err = 1;
			continue;
		}
                if (user.u_ttyp==0) {
                        if (xflg==0)
                                continue;
                        cs = "?";
                } else {
                        for(c=0; c<ndev; c++)
	                        if(devl[c] == user.u_ttyd) {
	                                cs = devc[c];
	                                goto out;
	                        }
                        for(c=0; c<ndev; c++)
	                        if(devl[c] == user.u_ttyd) {
	                                cs = devc[c];
	                                goto out;
	                        }
                        cs = "?";
                out:;
                }
                puid = proc[i].p_uid;
                if (uid != puid && aflg==0)
                        continue;
                if ((lflg || strcmp(cs, mtty)) && (strcmp(cs, "?")))
                        printf("%-6s", cs);
                else
                        printf("      ");
                if (lflg) {
                        printf("%3o %c%4d", proc[i].p_flag,
                                "0SWRIZT"[proc[i].p_stat], puid);
                }
                printf("%6d", proc[i].p_pid);
                if (lflg) {
                        printf(" %5d %5d %3d", proc[i].p_ppid, proc[i].p_pgrp, proc[i].p_pri);
                        if (proc[i].p_wchan)
                                /* this anding is a kludge. */
                                printf(" %6x", (int)proc[i].p_wchan & 0xffffff);
			else
                                printf("       ");
                        if (proc[i].p_stat!=SZOMB)
                                printf(" %02d/%02d", user.u_tseg.u_size, user.u_sseg.u_size + user.u_dseg.u_size);
			else
				printf("      ");
                }
		if (tflg && proc[i].p_stat != SZOMB) {
			prtime(user.u_utime, user.u_stime, proc[i].p_stat==SZOMB);
		}
                if (proc[i].p_stat==SZOMB)
                        printf("%s <defunct>", tflg ? "        " : "");
                else
                        err |= prcom(i);
                printf("\n");
        }
        done(err);
}

getdev()
{
        register i, c;
        int f;
        struct direct dbuf;
        struct stat sbuf;

        f = open("/dev",0);
        if(f < 0) {
                fprintf(stderr, "ps: cannot open /dev\n");
                done(1);
        }
        c = 0;

	for(;;) {
                i = read(f, (char *)&dbuf, sizeof dbuf);
                if(i <= 0) {
                        close(f);
                        ndev = c;
                        return;
                }
                if(dbuf.d_ino == 0)
                        continue;
                if(dbuf.d_name[0] == 't' &&
                   dbuf.d_name[1] == 't' &&
                   dbuf.d_name[2] == 'y' &&
                   dbuf.d_name[3] != 0) {
                        if(stat(dbuf.d_name, &sbuf) < 0)
                                continue;
                        strcpy(devc[c], dbuf.d_name);
                        devl[c] = sbuf.st_rdev;
                        c++;
                        continue;
                }
        }
}

prcom(i)
{
        register int *ip;
        register char *cp, *cp1;
        int c, nbad, addr;
	char abuf[512];

        if(i == 0) {    /* process 0 */
                return(0);
        }
        seek(mem, (int)user.u_sseg.u_pages, 0);
        if (read(mem, (char *)&pagetab, sizeof pagetab) != sizeof pagetab) {
		return(1);
	}
        addr = pagetab.pt_entry[PTSIZE - 1];
        addr = (addr >> 4) << 12;
	addr += (4096 - 512);
        seek(mem, addr, 0);
	if (read(mem, abuf, sizeof(abuf)) != sizeof(abuf))
		return(1);
	for (ip = (int *)&abuf[512]-2; ip > (int *)abuf; ) {
		if (*--ip == -1 || *ip==0) {
			cp = (char *)(ip+1);
			if (*cp==0)
				cp++;
			nbad = 0;
			for (cp1 = cp; cp1 < &abuf[512]; cp1++) {
				c = *cp1&0177;
				if (c==0)
					*cp1 = ' ';
				else if (c < ' ' || c > 0176) {
					if (++nbad >= 5) {
						*cp1++ = ' ';
						break;
					}
					*cp1 = '?';
				} else if (c=='=') {
					*cp1 = 0;
					while (cp1>cp && *--cp1!=' ')
						*cp1 = 0;
					break;
				}
			}
			while (*--cp1==' ')
				*cp1 = 0;
			printf(lflg?" %.21s":" %.60s", cp);
			return(1);
		}
	}
	return(0);
}

done(err)
{

        exit(err);
}

prtime(utime, stime, flg)
cpu_t   utime, stime;
int     flg;
{
	float f;

	f = (utime + stime) >> 12;  /* f is now time in microseconds */
	f /= 1000000;
	if (flg || f < 0)
		printf("        ");
	else
	        printf(" %7.03f", f);
}
