#include "dcon.h"
#include <signal.h>
#define NSIG 30		/* this should be in signal.h */
int errno;

/*
 * break point handling routines
 */

int pid = 0;
int trace = 0;
int lastbp = 0;
PSTATE state;
BP *bptail = NULL;
BP *bplook();
char *Null = "";
char *pargv[MAXNARGS];

/*
 * bit vector to distinguish program interrupts from others
 * pain in the arse!
 */

static char progint[] ={
	0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1,
	1, 1, 0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
	};

/*
 * qbp - add a break point to the list
 */

qbp(addr)
register int addr;{

	register BP *p, *bpp;

#ifndef NORWAY
	if (shared) {
		error(0, "text shared, cannot set break point");
		return(NULL);
		}
#endif
	for (bpp = bptail; bpp != NULL; bpp = bpp->bp_next) {
		if (bpp->bp_addr == addr)
			return(bpp);
		}
	p = calloc(1, sizeof(BP));
	p->bp_addr = addr;
	p->bp_next = bptail;
	p->bp_cmd = 0;
	p->bp_comment = Null;
	bptail = p;
	return(p);
	}

/*
 * begin tracing a process
 */

go(p)
register char *p;{

	register int i;
	register BP *bpp;
	int savec, status;

	if (shared)
	        if (close(fildes) != NULL)
		        error(1, "Couldn't close file %s", objname);
	if (trace) {
		kill(pid, SIGKILL);
		while (wait(&status) != pid);
		}
	pargv[0] = objname;
	while (*p==' ' || *p=='\t') p++;
	for (i = 1; *p; i++) {
		if (i >= MAXNARGS) {
			error(0, "too many args");
			break;
			}
		pargv[i] = p;
		while (*p!=' ' && *p!='\t' && *p!='\0') p++;
		if (*p != '\0') *p++ = '\0';
		while (*p==' ' || *p=='\t') p++;
		}
	pargv[i] = 0;
	if ((pid = fork()) == -1) {
		error(0, "Can't fork");
		return;
		}
	if (pid == 0) {
		sigtrace(0, SIGEXEC, 1);
		execv(objname, pargv);
		error(0, "Can't exec %s (errno=%d)", pargv[0], errno);
		exit(1);
		}
	while (wait(&status) != pid);
	if (shared)
	        if ((fildes = open(objname, 2)) == -1)
		        if ((fildes = open(objname, 0)) == -1)
			        error(1, "Can't reread/rewrite %s", objname);
	ptrace(pid, 0, &state);
	if (state.ps_sig != SIGEXEC) {
		return;
		}
	sigtrace(pid, SIGEXEC, 0);
	state.ps_sig = 0;
	if ((trace = offset) == 0)
		trace = -1;
	offset = 0;
	if ((bpp = bplook(0)) != NULL) {
		printf("Break point at 0\t%s\n", bpp->bp_comment);
		if (bpp->bp_cmd)
			doreq(bpp->bp_cmd, 1);
		dotdot = lastbp = 0;
		for (i = 1; i < NSIG; i++)
			sigtrace(pid, i, 1);
		}
	else cont(0);
	}

/*
 * cont - start execution at the specified location
 *	we have to be careful here because if the location we
 *	want to start at is a break point, we can't go setting
 *	all the break points and then continuing the process (otherwise
 *	the location could never be executed).  So we single step
 *	through the location if it's a break point and then
 *	breeze along as usual.
 */

cont(loc)
register int loc;{

	register PSTATE *p = &state;
	register BP *bpp;
	register char *s;
	int c, status;

	if (!trace) {
		error(0, "no process to continue");
		return;
		}
	p->ps_pc = loc;
	if ((bpp = bplook(loc)) != NULL) {
		if (ss(loc)) return;
		}
	setbps();
	ptrace(pid, 1, &state);

	while (wait(&status) != pid);
	ptrace(pid, 0, &state);
	lastbp = p->ps_pc;
	if (progint[p->ps_sig]) lastbp -= ILC;
	dotdot = lastbp;
	unsetbps();
	if ((status&0177)!=0177 || p->ps_sig != SIGINS) {
		prtsig(dotdot, status);
		return;
		}
	if ((bpp = bplook(dotdot)) != NULL) {
		p->ps_sig = 0;
		printf("Break point at ");
		pname(bpp->bp_addr, N_TEXT);
		printf("\t%s\n", bpp->bp_comment);
		if (bpp->bp_cmd)
			doreq(bpp->bp_cmd, 1);
		return;
		}
	printf("couldn't find break point at %6x\n", loc);
	prtsig(dotdot, status);
	}

/*
 * setbps - set the break points on the list
 *	accomplished by zapping the referenced word while saving it's value
 *	also catch all signals in child, ignore in parent
 */

setbps(){

	register BP *p;
	register int i;
	int x = 0;

	for (p = bptail; p != NULL; p = p->bp_next) {
		pio(pid, READ, p->bp_addr, &(p->bp_val), BPHW);
		pio(pid, WRITE, p->bp_addr, &x, BPHW);
		}
	for (i = 1; i < NSIG; i++) {
		signal(i, 1);
		sigtrace(pid, i, 1);
		}
	}

/*
 * unsetbps - undo all the dirty work done above
 */

unsetbps(){

	register BP *p;
	register int i;
	int catchsig();

	for (p = bptail; p != NULL; p = p->bp_next)
		pio(pid, WRITE, p->bp_addr, &(p->bp_val), BPHW);
	for (i = 4; i < NSIG; i++)
		signal(i, 0);
	for (i = 1; i < 4; i++)
		signal(i, catchsig);
	}

/*
 * single step from specified location
 *	this is a pain because basically you have to
 *	set a break point at the next instruction (wherever it may be),
 *	then execute and unset
 */

static int m[] { 8, 4, 2, 1 };

ss(loc)
register int loc;{

	register PSTATE *p = &state;
	register struct optab *pop;
	struct op470 w;
	int cc, status;

	if (!trace) {
		error(0, "no process to single step");
		return;
		}
	p->ps_pc = loc;
	pio(pid, READ, loc, &w, BPW);
	if (w.opcode == SVC)
		pop = &op[0];
	else if ((pop = oplookup(w.opcode)) == NULL)
		if (w.sopcode > 0377)
			pop = oplookup(w.sopcode);
	if (pop == NULL) {
		printf("Can't recognize opcode: %4x\n", w.sopcode);
		printf("Operation exception at location ");
		pname(loc, N_TEXT);
		putchar('\n');
		return(-1);
		}
	cc = (p->ps_ps >> 12)&03;
	switch(pop->op_type) {
		case RR:
			if (pop->op_val == BALR)
				loc = p->ps_gpr[w.r2];
			else loc += BPHW;
			break;
		case SS1:
		case SS2:
		case SS3:
			loc += BPW+BPHW;
			break;
		default:
			if (pop->op_val == BAL) {
				loc = w.disp1;
				if (w.r2) loc += p->ps_gpr[w.r2];
				if (w.base1) loc += p->ps_gpr[w.base1];
				}
			else loc += BPW;
			break;
		case BRANCHR:
			if (m[cc]&w.r1)
				loc = p->ps_gpr[w.r2]&0xffffff;
			else loc += BPHW;
			break;
		case BRANCH:
			if (m[cc]&w.r1) {
				loc = w.disp1;
				if (w.r2) loc += p->ps_gpr[w.r2];
				if (w.base1) loc += p->ps_gpr[w.base1];
				}
			else loc += BPW;
			break;
		}
	cc = 0;
	pio(pid, READ, loc, &w, BPHW);
	pio(pid, WRITE, loc, &cc, BPHW);
	ptrace(pid, 1, &state);

	while (wait(&status) != pid);
	ptrace(pid, 0, &state);
	dotdot = p->ps_pc;
	if (progint[p->ps_sig]) dotdot -= ILC;
	if (dotdot != loc || p->ps_sig != SIGINS) {
		prtsig(dotdot, status);
		return(-1);
		}
	pio(pid, WRITE, loc, &w, BPHW);
	p->ps_pc = dotdot;
	p->ps_sig = 0;
	return(0);
	}

/*
 * prtsig - print out a signal
 *	special case for signal 0 -- that means the process terminated
 */

prtsig(loc, status)
register int loc, status;{

	register int retcode;

	if ((status&0177)!=0177) {
		printf("process terminated");
		if ((status&0377)==0)
			printf(", returns %d\n", (status>>bPB)&0377);
		else printf(" by signal %d\n", status&0377);
		if ((offset = trace) == -1)
			offset = 0;
		trace = 0;
		return;
		}
	printf("%s at location ", signame[state.ps_sig]);
	pname(loc, N_TEXT);
	putchar('\n');
	}

/*
 * check to see if a location is a break point
 */

BP *bplook(loc)
register int loc;{

	register BP *p;

	for (p = bptail; p != NULL; p = p->bp_next) {
		if (p->bp_addr == loc) return(p);
		}
	return(NULL);
	}

/*
 * clear a break point
 */

bpclear(loc)
register int loc;{

	register BP *p, *last;

	last = NULL;
	for (p = bptail; p != NULL; p = p->bp_next) {
		if (p->bp_addr == loc) {
			if (last == NULL)
				bptail = p->bp_next;
			else last->bp_next = p->bp_next;
			if (p->bp_cmd) cfree(p->bp_cmd);
			if (p->bp_comment != Null) cfree(p->bp_comment);
			cfree(p);
			return;
			}
		last = p;
		}
	error(0, "no break point at %6x", loc);
	}

/*
 * display current break points
 */

dbrks(){

	register BP *p;

	if (bptail == NULL) {
		printf("no break points set\n");
		return;
		}
	printf("break points:\n");
	for (p = bptail; p != NULL; p = p->bp_next) {
		printf("   ");
		pname(p->bp_addr, N_TEXT);
		if (p->bp_comment != Null)
			printf("\t/* %s", p->bp_comment);
		putchar('\n');
		}
	}
